/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.safehtml.shared.annotations.IsSafeUri;
import com.google.gwt.safehtml.shared.annotations.SuppressIsSafeHtmlCastCheck;
import com.google.gwt.user.client.ui.DirectionalTextHelper;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasDirectionalSafeHtml;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasWordWrap;
import com.google.gwt.user.client.ui.RootPanel;

public class Anchor
extends FocusWidget
implements HasHorizontalAlignment,
HasName,
HasHTML,
HasWordWrap,
HasDirection,
HasDirectionEstimator,
HasDirectionalSafeHtml {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    private static final String DEFAULT_HREF = "javascript:;";
    private final DirectionalTextHelper directionalTextHelper;
    private HasHorizontalAlignment.HorizontalAlignmentConstant horzAlign;

    public static Anchor wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Anchor anchor = new Anchor(element);
        anchor.onAttach();
        RootPanel.detachOnWindowClose(anchor);
        return anchor;
    }

    public Anchor() {
        this(false);
    }

    public Anchor(boolean useDefaultHref) {
        this.setElement(Document.get().createAnchorElement());
        this.setStyleName("gwt-Anchor");
        this.directionalTextHelper = new DirectionalTextHelper(this.getAnchorElement(), true);
        if (useDefaultHref) {
            this.setHref(DEFAULT_HREF);
        }
    }

    public Anchor(SafeHtml html) {
        this(html.asString(), true);
    }

    public Anchor(SafeHtml html, HasDirection.Direction dir) {
        this(html.asString(), true, dir, DEFAULT_HREF);
    }

    public Anchor(SafeHtml html, DirectionEstimator directionEstimator) {
        this(html.asString(), true, directionEstimator, DEFAULT_HREF);
    }

    public Anchor(String text) {
        this(text, DEFAULT_HREF);
    }

    public Anchor(String text, HasDirection.Direction dir) {
        this(text, dir, DEFAULT_HREF);
    }

    public Anchor(String text, DirectionEstimator directionEstimator) {
        this(text, directionEstimator, DEFAULT_HREF);
    }

    public Anchor(@IsSafeHtml String text, boolean asHtml) {
        this(text, asHtml, DEFAULT_HREF);
    }

    public Anchor(SafeHtml html, @IsSafeUri String href) {
        this(html.asString(), true, href);
    }

    public Anchor(SafeHtml html, SafeUri href) {
        this(html.asString(), true, href.asString());
    }

    public Anchor(SafeHtml html, HasDirection.Direction dir, @IsSafeUri String href) {
        this(html.asString(), true, dir, href);
    }

    public Anchor(SafeHtml html, HasDirection.Direction dir, SafeUri href) {
        this(html.asString(), true, dir, href.asString());
    }

    public Anchor(SafeHtml html, DirectionEstimator directionEstimator, @IsSafeUri String href) {
        this(html.asString(), true, directionEstimator, href);
    }

    public Anchor(SafeHtml html, DirectionEstimator directionEstimator, SafeUri href) {
        this(html.asString(), true, directionEstimator, href.asString());
    }

    @SuppressIsSafeHtmlCastCheck
    public Anchor(String text, @IsSafeUri String href) {
        this(text, false, href);
    }

    @SuppressIsSafeHtmlCastCheck
    public Anchor(String text, HasDirection.Direction dir, @IsSafeUri String href) {
        this(text, false, dir, href);
    }

    @SuppressIsSafeHtmlCastCheck
    public Anchor(String text, DirectionEstimator directionEstimator, @IsSafeUri String href) {
        this(text, false, directionEstimator, href);
    }

    public Anchor(@IsSafeHtml String text, boolean asHTML, @IsSafeUri String href) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setHref(href);
    }

    public Anchor(SafeHtml html, @IsSafeUri String href, String target) {
        this(html.asString(), true, href, target);
    }

    public Anchor(SafeHtml html, SafeUri href, String target) {
        this(html.asString(), true, href.asString(), target);
    }

    @SuppressIsSafeHtmlCastCheck
    public Anchor(String text, @IsSafeUri String href, String target) {
        this(text, false, href, target);
    }

    public Anchor(@IsSafeHtml String text, boolean asHtml, @IsSafeUri String href, String target) {
        this(text, asHtml, href);
        this.setTarget(target);
    }

    protected Anchor(Element element) {
        AnchorElement.as(element);
        this.setElement(element);
        this.directionalTextHelper = new DirectionalTextHelper(this.getAnchorElement(), true);
    }

    private Anchor(@IsSafeHtml String text, boolean asHTML, HasDirection.Direction dir, @IsSafeUri String href) {
        this();
        this.directionalTextHelper.setTextOrHtml(text, dir, asHTML);
        this.setHref(href);
    }

    private Anchor(@IsSafeHtml String text, boolean asHTML, DirectionEstimator directionEstimator, @IsSafeUri String href) {
        this();
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
        this.directionalTextHelper.setTextOrHtml(text, asHTML);
        this.setHref(href);
    }

    @Override
    public HasDirection.Direction getDirection() {
        return BidiUtils.getDirectionOnElement(this.getElement());
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.directionalTextHelper.getDirectionEstimator();
    }

    @Override
    public HasHorizontalAlignment.HorizontalAlignmentConstant getHorizontalAlignment() {
        return this.horzAlign;
    }

    public String getHref() {
        return this.getAnchorElement().getHref();
    }

    @Override
    public String getHTML() {
        return this.getElement().getInnerHTML();
    }

    @Override
    public String getName() {
        return this.getAnchorElement().getName();
    }

    @Override
    public int getTabIndex() {
        return this.getAnchorElement().getTabIndex();
    }

    public String getTarget() {
        return this.getAnchorElement().getTarget();
    }

    @Override
    public String getText() {
        return this.directionalTextHelper.getText();
    }

    @Override
    public HasDirection.Direction getTextDirection() {
        return this.directionalTextHelper.getTextDirection();
    }

    @Override
    public boolean getWordWrap() {
        return !Style.WhiteSpace.NOWRAP.getCssName().equals(this.getElement().getStyle().getWhiteSpace());
    }

    @Override
    public void setAccessKey(char key) {
        this.getAnchorElement().setAccessKey(Character.toString(key));
    }

    @Override
    @Deprecated
    public void setDirection(HasDirection.Direction direction) {
        this.directionalTextHelper.setDirection(direction);
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.directionalTextHelper.setDirectionEstimator(enabled);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionalTextHelper.setDirectionEstimator(directionEstimator);
    }

    @Override
    public void setFocus(boolean focused) {
        if (focused) {
            this.getAnchorElement().focus();
        } else {
            this.getAnchorElement().blur();
        }
    }

    @Override
    public void setHorizontalAlignment(HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this.horzAlign = align;
        this.getElement().getStyle().setProperty("textAlign", align.getTextAlignString());
    }

    public void setHref(SafeUri href) {
        this.getAnchorElement().setHref(href);
    }

    public void setHref(@IsSafeUri String href) {
        this.getAnchorElement().setHref(href);
    }

    @Override
    public void setHTML(SafeHtml html) {
        this.directionalTextHelper.setHtml(html);
    }

    @Override
    public void setHTML(@IsSafeHtml String html) {
        this.directionalTextHelper.setHtml(html);
    }

    @Override
    public void setHTML(SafeHtml html, HasDirection.Direction dir) {
        this.directionalTextHelper.setHtml(html, dir);
    }

    @Override
    public void setName(String name) {
        this.getAnchorElement().setName(name);
    }

    @Override
    public void setTabIndex(int index) {
        this.getAnchorElement().setTabIndex(index);
    }

    public void setTarget(String target) {
        this.getAnchorElement().setTarget(target);
    }

    @Override
    public void setText(String text) {
        this.directionalTextHelper.setText(text);
    }

    @Override
    public void setText(String text, HasDirection.Direction dir) {
        this.directionalTextHelper.setText(text, dir);
    }

    @Override
    public void setWordWrap(boolean wrap) {
        this.getElement().getStyle().setWhiteSpace(wrap ? Style.WhiteSpace.NORMAL : Style.WhiteSpace.NOWRAP);
    }

    private AnchorElement getAnchorElement() {
        return AnchorElement.as(this.getElement());
    }
}

